#include <balancer/kernel/cookie/utils/utils.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel::NCookie;

Y_UNIT_TEST_SUITE(TCookieUtilsTest) {
    Y_UNIT_TEST(TestSkipDot) {
        UNIT_ASSERT_VALUES_EQUAL(SkipDot({}), "");
        UNIT_ASSERT_VALUES_EQUAL(SkipDot("a"), "a");
        UNIT_ASSERT_VALUES_EQUAL(SkipDot(".a"), "a");
        UNIT_ASSERT_VALUES_EQUAL(SkipDot("..a"), ".a");
        UNIT_ASSERT_VALUES_EQUAL(SkipDot("."), "");
        UNIT_ASSERT_VALUES_EQUAL(SkipDot(".."), ".");
    }

    Y_UNIT_TEST(TestRSkipDot) {
        UNIT_ASSERT_VALUES_EQUAL(RSkipDot({}), "");
        UNIT_ASSERT_VALUES_EQUAL(RSkipDot("a"), "a");
        UNIT_ASSERT_VALUES_EQUAL(RSkipDot("a."), "a");
        UNIT_ASSERT_VALUES_EQUAL(RSkipDot("a.."), "a.");
        UNIT_ASSERT_VALUES_EQUAL(RSkipDot("."), "");
        UNIT_ASSERT_VALUES_EQUAL(RSkipDot(".."), ".");
    }

    Y_UNIT_TEST(TestStripPort) {
        UNIT_ASSERT_VALUES_EQUAL(StripPort("yandex"), "yandex");
        UNIT_ASSERT_VALUES_EQUAL(StripPort("yandex:80"), "yandex");
        UNIT_ASSERT_VALUES_EQUAL(StripPort("[::1]:80"), "[::1]");
    }
}
