#include "channel.h"

namespace NSrvKernel {
    TSimplePipeEventImpl::TSimplePipeEventImpl() {
        TPipeHandle::Pipe(ReceivePipe_, SendPipe_);
        SetNonBlock(ReceivePipe_);
        SetNonBlock(SendPipe_);
    }

    void TSimplePipeEventImpl::Signal() {
        char tmp = 1;
        if (1 != SendPipe_.Write(&tmp, 1)) {
            ythrow TSystemError() << "can't write to pipe";
        }
    }

}  // namespace NSrvKernel

#ifdef _linux_

namespace NSrvKernel {
    TEventFdEventImpl::TEventFdEventImpl()
        : Fd_(eventfd(0, EFD_NONBLOCK))
    {
        if (Fd_ < 0) {
            ythrow TSystemError() << "can't create eventfd";
        }
    }

    TEventFdEventImpl::~TEventFdEventImpl() {
        close(Fd_);
    }

    void TEventFdEventImpl::Signal() {
        if (0 != eventfd_write(Fd_, 1)) {
            ythrow TSystemError() << "can't write to eventfd";
        }
    }
}  // namespace NSrvKernel

#endif
