#include "coro_cond_var.h"

#include <library/cpp/coroutine/engine/impl.h>

namespace NSrvKernel {

int TCoroSingleCondVar::wait_until(TContExecutor* const exec, TInstant deadline) noexcept {
    // We allow only one coroutine to wait for event simultaneously.
    Y_VERIFY(Event_ == nullptr);

    TTimerEvent event{exec->Running(), deadline};
    Event_ = &event;
    int ret = ExecuteEvent(Event_);

    Event_ = nullptr;

    return ret;
}

void TCoroSingleCondVar::notify() noexcept {
    if (Event_ != nullptr && !Event_->Cont()->Scheduled()) {
        Event_->Wake(EWAKEDUP);
    }
}

}  // namespace NSrvKernel
