#include "coro_event.h"

#include <library/cpp/coroutine/engine/impl.h>

namespace NSrvKernel {

int TCoroManualEvent::wait_until(TContExecutor* const exec, TInstant deadline) noexcept {
    int ret = 0; // = 0 for carzil

    // We don't need to wait for event in cycle since there
    // can't be spurious wakeups in coroutines.
    if (!Done_) {
        ret = CV_.wait_until(exec, deadline);
    }
    // We need to check it again because wait_until() in CV_ may return
    // ECANCELED even if notify() actually happen. It may happen
    // because of wrong logic in ExecuteEvent() in library/cpp/coroutine.
    if (Done_) {
        return EWAKEDUP;
    }
    return ret;
}

}  // namespace NSrvKernel
