#pragma once

#include <library/cpp/coroutine/engine/impl.h>

namespace NSrvKernel {

    class TOwnExecutor {
    public:
        class TImpl
            : public TContExecutor
        {
        public:
            TImpl(size_t coroStackSize, TStringBuf pollName, bool guard,
                TMaybe<NCoro::NStack::TPoolAllocatorSettings> poolSettings,
                NCoro::IEnterPollerCallback* enterPollerCallback,
                NCoro::IScheduleCallback* scheduleCallback) noexcept
            : TContExecutor(
                coroStackSize,
                IPollerFace::Construct(pollName),
                scheduleCallback,
                enterPollerCallback,
                guard ? NCoro::NStack::EGuard::Page : NCoro::NStack::EGuard::Canary,
                poolSettings
            ) {}
        };

    public:
        TOwnExecutor(size_t coroStackSize, TStringBuf pollName, bool guard,
                     TMaybe<NCoro::NStack::TPoolAllocatorSettings> poolSettings,
                     NCoro::IEnterPollerCallback* enterPollerCallback,
                     NCoro::IScheduleCallback* scheduleCallback = nullptr) noexcept
            : Executor_(coroStackSize, pollName, guard, poolSettings, enterPollerCallback, scheduleCallback)
        {}

        TContExecutor& Executor() noexcept {
            return Executor_;
        }

    private:
        TImpl Executor_;
    };
}
