#pragma once

#include <library/cpp/coroutine/engine/impl.h>

namespace NSrvKernel {
    [[nodiscard]]
    inline int UniversalSleep(TDuration duration) {
        TCont* cont = RunningCont();
        if (cont) {
            return cont->SleepT(duration);
        } else {
            Sleep(duration);
        }
        return 0;
    }

    [[nodiscard]]
    inline int UniversalSleepUntil(TInstant deadline) {
        TCont* cont = RunningCont();
        if (cont) {
            return cont->SleepD(deadline);
        } else {
            SleepUntil(deadline);
        }
        return 0;
    }
}
