#include <balancer/kernel/coro/cleanable_coro_storage.h>

#include <balancer/kernel/testing/testing.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TCleanableCoroStorageTest) {
    constexpr size_t ITER_COUNT = 5;

    CORO_TEST_BEGIN(SmokingTest, exec) {
        TCleanableCoroStorage storage;
        UNIT_ASSERT_EQUAL(0, storage.Size());

        storage.EraseFinished();
        UNIT_ASSERT_EQUAL(0, storage.Size());

        bool done = false;
        storage.Emplace("SmokingTest", exec, [&done] {
            done = true;
        });
        UNIT_ASSERT(!done);
        UNIT_ASSERT_EQUAL(1, storage.Size());

        storage.EraseFinished();
        UNIT_ASSERT(!done);
        UNIT_ASSERT_EQUAL(1, storage.Size());

        exec->Running()->Yield();
        UNIT_ASSERT(done);
        UNIT_ASSERT_EQUAL(0, storage.Size());

        storage.EraseFinished();
        UNIT_ASSERT_EQUAL(0, storage.Size());
    } CORO_TEST_END

    CORO_TEST_BEGIN(DestructorTest, exec) {
        int cnt = 0;
        {
            TCleanableCoroStorage storage;
            UNIT_ASSERT_EQUAL(0, storage.Size());

            for (size_t i = 0; i < ITER_COUNT; ++i) {
                storage.Emplace("DestructorTest", exec, [&cnt] {
                    ++cnt;
                });
            }
            UNIT_ASSERT_EQUAL(0, cnt);
            UNIT_ASSERT_EQUAL(ITER_COUNT, storage.Size());
        }
        UNIT_ASSERT_EQUAL(ITER_COUNT, cnt);
    } CORO_TEST_END
}
