#pragma once

#include <balancer/kernel/helpers/errors.h>
#include <balancer/kernel/coro/coroutine.h>

#include <util/datetime/base.h>

#include <functional>

class TContExecutor;

namespace NSrvKernel {

    struct TCpuAndTimeDelta {
        TDuration TotalUsage;
        TDuration MeasureTime;
    };

    TErrorOr<TCpuAndTimeDelta> MeasureCpuAndTime(TContExecutor& contExecutor, TDuration duration) noexcept;

    class ICpuMeasureCallback {
    public:
        virtual void OnMeasure(TCpuAndTimeDelta delta) = 0;
    };

    TCoroutine StartCpuAndTimeMeasurer(
        TContExecutor& exec,
        ICpuMeasureCallback* measureCallback1,
        ICpuMeasureCallback* measureCallback2
    ) noexcept;

}
