#pragma once

#include <util/generic/flags.h>
#include <util/generic/ptr.h>
#include <util/system/defaults.h>

namespace NSrvKernel {
    class TTwoNonblockingPipes;
}

namespace NSrvKernel::NProcessCore {
    enum class TChildProcessType : ui32 {
        Default = 1ull << 0 /* "worker" */,
        Pinger = 1ull << 1 /* "pinger" */,
        Updater = 1ull << 2 /* "updater" */,
        QuotaSyncer = 1ull << 3 /* "quota_syncer" */,
        StorageGC = 1ull << 4 /* "cache_cleaner" */,
        ConnectionManager = 1ull << 5 /* "connection_manager" */
    };
    Y_DECLARE_FLAGS(TChildProcessMask, TChildProcessType);

    inline size_t ChildProcessTypeToIndex(TChildProcessType type) {
        switch (type) {
            case TChildProcessType::Default:
                return 0;
            case TChildProcessType::Pinger:
                return 1;
            case TChildProcessType::Updater:
                return 2;
            case TChildProcessType::QuotaSyncer:
                return 3;
            case TChildProcessType::StorageGC:
                return 4;
            case TChildProcessType::ConnectionManager:
                return 5;
        }
    }
}
