#pragma once

#include <balancer/kernel/custom_io/null.h>
#include <balancer/kernel/io/iobase.h>
#include <balancer/kernel/memory/chunks.h>

namespace NSrvKernel {
    class TConcatInput : public IIoInput {
    public:
        TConcatInput(IIoInput* f, IIoInput* s) noexcept
            : F_(f)
            , S_(s)
        {}

    private:
        TError DoRecv(TChunkList& lst, TInstant deadline) noexcept override {
            Y_PROPAGATE_ERROR(F_->Recv(lst, deadline));

            if (lst.Empty()) {
                F_ = S_;
                S_ = &Null_;

                Y_PROPAGATE_ERROR(F_->Recv(lst, deadline));
            }
            return {};
        }

    private:
        IIoInput* F_ = nullptr;
        IIoInput* S_ = nullptr;
        TNullStream Null_;
    };
}
