#pragma once

#include <balancer/kernel/helpers/default_instance.h>
#include <balancer/kernel/io/iobase.h>
#include <balancer/kernel/memory/chunks.h>

#include <util/datetime/base.h>

namespace NSrvKernel {

    // Before trying to make it a singleton, see BALANCER-782
    class TNullStream : public IIoInput, public IHttpOutput {
    private:
        TError DoRecv(TChunkList&, TInstant) noexcept override {
            return {};
        }

        TError DoSendHead(TResponse&&, const bool, TInstant) override {
            return {};
        }

        TError DoSendTrailers(THeaders&&, TInstant) override {
            return {};
        }

        TError DoSend(TChunkList, TInstant) noexcept override {
            return {};
        }
    };
}
