#include <balancer/kernel/custom_io/chunkio.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TBalancerChunkioTest) {
    using namespace NSrvKernel;
    const TStringBuf DATA = "test0test1test2test3test4";

    Y_UNIT_TEST(TestChunksIo) {
        TChunkList chunk;
        TChunksIo io;

        chunk.PushNonOwning(DATA);

        Y_UNUSED(io.Send(std::move(chunk), TInstant::Max()));
        UNIT_ASSERT(chunk.Empty());
        UNIT_ASSERT_EQUAL(io.Chunks(), DATA);

        Y_UNUSED(io.Recv(chunk, TInstant::Max()));
        UNIT_ASSERT(io.Chunks().Empty());
        UNIT_ASSERT_EQUAL(chunk, DATA);
    }

    Y_UNIT_TEST(TestChunksOutput) {
        TChunkList chunk;
        TChunksOutput out;

        chunk.PushNonOwning(DATA);

        Y_UNUSED(out.Send(std::move(chunk), TInstant::Max()));
        UNIT_ASSERT(chunk.Empty());
        UNIT_ASSERT_EQUAL(out.Chunks(), DATA);

        TChunkList otherChunk(std::move(out).Chunks());
        UNIT_ASSERT(out.Chunks().Empty());
        UNIT_ASSERT_EQUAL(otherChunk, DATA);

        out.Chunks().PushNonOwning(DATA);
        UNIT_ASSERT_EQUAL(out.Chunks(), DATA);
    }

    Y_UNIT_TEST(TestChunksInput) {
        TChunkList chunk;

        chunk.PushNonOwning(DATA);

        TChunksInput in1(chunk.Copy());
        UNIT_ASSERT_EQUAL(chunk, DATA);
        chunk.Clear();
        UNIT_ASSERT(chunk.Empty());
        Y_UNUSED(in1.Recv(chunk, TInstant::Max()));
        UNIT_ASSERT_EQUAL(chunk, DATA);

        TChunksInput in2(std::move(chunk));
        UNIT_ASSERT(chunk.Empty());
        Y_UNUSED(in2.Recv(chunk, TInstant::Max()));
        UNIT_ASSERT_EQUAL(chunk, DATA);

        TChunksOutput out;
        Y_UNUSED(out.Send(std::move(chunk), TInstant::Max()));
        TChunksInput in3(out.Chunks().Copy());
        UNIT_ASSERT(chunk.Empty());
        Y_UNUSED(in3.Recv(chunk, TInstant::Max()));
        UNIT_ASSERT_EQUAL(chunk, DATA);

        TChunksInput in4(std::move(out.Chunks()));
        UNIT_ASSERT(out.Chunks().Empty());
        chunk.Clear();
        Y_UNUSED(in4.Recv(chunk, TInstant::Max()));
        UNIT_ASSERT_EQUAL(chunk, DATA);

    }

};
