#pragma once

#include <util/datetime/base.h>


class TContExecutor;

namespace NSrvKernel {

struct TSockAddrInfo;

namespace NDns {

class ICounters;
class IEntry;
struct TDnsServer;
struct TOptions;

//! Implements coroutine logic inside
class IAsyncCoro {
public:
    virtual ~IAsyncCoro() = default;

    //! Try to resolve host till deadline. After method returns, result struct
    //! is not needed any more and can be freed by it's owner.
    virtual bool Resolve(const TString& host, int family, TInstant deadline, IEntry& result) noexcept = 0;
};

THolder<IAsyncCoro> MakeContAsyncResolver(TContExecutor* e, const TOptions& opts, ICounters& counters, const TDnsServer& server);

}
}