#pragma once

#include "async_coro_requests_i.h"

#include <library/cpp/coroutine/engine/events.h>

#include <util/generic/scope.h>


class TContExecutor;

namespace NSrvKernel::NDns {


class TCoroRequests final : public ICoroRequests {
public:
    TCoroRequests(TContExecutor& executor);

    bool ExecuteRequest(const TString& host,
                        int family,
                        TInstant deadline,
                        ScheduleFunc scheduler,
                        ICounters& counters,
                        IEntry& result) noexcept override;
    size_t Size() const noexcept override { return Requests_.Size(); }

private:
    TContExecutor& Executor_;
    TIntrusiveList<IRequest> Requests_;
};

}