#pragma once

#include <balancer/kernel/dns/async_wrapper_i.h>
#include <balancer/kernel/dns/async_entry_i.h>

#include <functional>

namespace NSrvKernel {

struct TSockAddrInfo;

namespace NDns {

class ICounters;

class IRequest : public TIntrusiveListItem<IRequest>, public IHostResult {
public:
    virtual ~IRequest() = default;

    virtual TString Host() const noexcept = 0;
    virtual int Family() const noexcept = 0;
    virtual int WaitD(TInstant deadline) noexcept = 0;
};

// Should be noexcept
using ScheduleFunc = std::function<void(IRequest& req)>;

class ICoroRequests {
public:
    virtual ~ICoroRequests() = default;

    virtual bool ExecuteRequest(const TString& host,
                                int family,
                                TInstant deadline,
                                ScheduleFunc scheduler,
                                ICounters& counters,
                                IEntry& result) noexcept = 0;
    virtual size_t Size() const noexcept = 0;
};

}
}