# pragma once

#include <balancer/kernel/net/addr.h>

class TContExecutor;

namespace NSrvKernel::NDns {

enum EResolveState {
    RS_NOT_RESOLVED,
    RS_IN_PROGRESS,
    RS_RESOLVED,
    RS_FAILED
};

class IEntry {
public:
    virtual ~IEntry() = default;

    virtual EResolveState GetState() const noexcept = 0;

    virtual const TSockAddrInfo& GetAddrInfo() const noexcept = 0;

    virtual bool HasValidResult() const noexcept = 0;

    virtual bool IsExpired(TDuration ttl) const noexcept = 0;

    virtual bool HasRequestsInProgress() const noexcept = 0;

    // Should be called on request creation/destruction
    virtual void AddRequestInProgress() noexcept = 0;
    virtual bool SetFailedIfDone() noexcept = 0;

    virtual void AddResult(TSockAddr&& result) noexcept = 0;

    virtual bool WaitD(TInstant deadline, int& waitResultCode) noexcept = 0;

    virtual void SetInProgress() noexcept = 0;

    virtual bool ResetFailedIfExpired(TDuration ttl) noexcept = 0;
};

using TEntryHolder = THolder<IEntry>;

class IEntryBuilder {
public:
    virtual ~IEntryBuilder() = default;

    virtual TEntryHolder GetNewEntry(TContExecutor* e, TDuration ttl) const = 0;
};

}