#pragma once

#include "resolver_config.h"
#include "resolver_face.h"

#include <balancer/kernel/helpers/errors.h>


class TContExecutor;

namespace NSrvKernel::NDns {

class IAsyncCache;
class IAsyncCoro;
class ICounters;

//! For use in single thread only
class TAsyncResolver final : public IResolver {
public:
    TAsyncResolver(TContExecutor* executor, TStatsCounters& counters, const TResolverConfig& config);
    TAsyncResolver(const TAsyncResolver&) = delete;
    TAsyncResolver(TAsyncResolver&&) = delete;
    TAsyncResolver& operator=(const TAsyncResolver&) = delete;
    TAsyncResolver& operator=(TAsyncResolver&&) = delete;
    ~TAsyncResolver() override;

private:
    TErrorOr<TSockAddrInfo> DoResolve(const TResolveInfo& info, bool onlyCache, TInstant deadline) override;
    void DoResetCache() override;

private:
    TContExecutor* Executor_ = nullptr; // not owned
    const TResolverConfig Config_;

    TStatsCounters& Counters_;
    THolder<ICounters> ResolveCounters_;
    THolder<IAsyncCache> Cache_;
};

}