#pragma once

#include "async_simple_resolver_i.h"

#include <util/generic/ptr.h>

namespace NSrvKernel::NDns {

class IAsyncSimpleWrapper;

class TAsyncSimpleResolver : public IAsyncSimpleResolver {
public:
    TAsyncSimpleResolver(TDuration resolveTimeout);
    ~TAsyncSimpleResolver() override;

    void StartResolve(THosts& hostToIp, int family) noexcept override;
    void WaitForResults(TDuration timeout) noexcept override;

    void OnComplete(int status, const hostent* he) noexcept override;

private:
    THolder<IAsyncSimpleWrapper> Resolver_;
    THosts* HostToIp_ = nullptr; // not owned
    bool HasRequests_ = false;
};

}