#pragma once

#include <balancer/kernel/dns/async_wrapper_i.h>

#include <util/generic/hash.h>

namespace NSrvKernel::NDns {

class IAsyncSimpleResolver : public IHostResult {
public:
    using THosts = THashMap<TString, TString>;

    virtual void StartResolve(THosts& hostToIp, int family) noexcept = 0;
    virtual void WaitForResults(TDuration timeout) noexcept = 0;
};

}