#pragma once

#include <balancer/kernel/dns/common.h>

#include <util/network/socket.h>

namespace NSrvKernel::NDns {

//! Encapsulates c-ares API. Simple and straightforward, without socket callbacks.
class IAsyncSimpleWrapper {
public:
    virtual ~IAsyncSimpleWrapper() = default;

    virtual void AsyncResolve(const char* addr, int family, IHostResult* cb) noexcept = 0;
    virtual void CancelRequests() noexcept = 0;
    virtual void WaitRequests(TDuration timeout) noexcept = 0;
};

}