#pragma once

#include "async_wrapper_i.h"


namespace NSrvKernel::NDns {

struct TDnsServer;
struct TOptions;

class TAsyncWrapper final : public IAsyncWrapper {
public:
    TAsyncWrapper(SocketStateCb socketCb, const TOptions& opts);
    //! With IPv4 DNS server. Generally, for using in tests.
    TAsyncWrapper(SocketStateCb socketCb, const TOptions& opts, const TDnsServer& server);
    ~TAsyncWrapper() override;

    void AsyncResolve(const char* addr, int family, IHostResult* cb) noexcept override;
    void CancelRequests() noexcept override;
    void ProcessSocket(SOCKET s) noexcept override;
    void ProcessNone() noexcept override;

private:
    static void SocketStateCbInternal(void* arg, int s, int read, int write) noexcept;
    static void ResolveHostCbInternal(void *arg, int status, int timeouts, hostent *he) noexcept;

private:
    const SocketStateCb SocketCb_; // noexcept
    ares_channel Channel_;
};

}