#pragma once

#include <balancer/kernel/dns/common.h>

#include <util/network/socket.h>

#include <functional>

namespace NSrvKernel::NDns {

// Should be noexcept
using SocketStateCb = std::function<void(ares_socket_t socket_fd, int readable, int writable)>;

//! Encapsulates c-ares API
class IAsyncWrapper {
public:
    virtual ~IAsyncWrapper() = default;

    virtual void AsyncResolve(const char* addr, int family, IHostResult* cb) noexcept = 0;
    virtual void CancelRequests() noexcept = 0;
    virtual void ProcessSocket(SOCKET s) noexcept = 0;
    virtual void ProcessNone() noexcept = 0;
};

}