#include <library/cpp/testing/unittest/registar.h>

#include <balancer/kernel/dns/async_simple/async_simple_resolver.h>


using namespace NSrvKernel::NDns;

Y_UNIT_TEST_SUITE(TestSimpleResolver) {

    Y_UNIT_TEST(TestResolveIPv4) {
        TAsyncSimpleResolver resolver(TDuration::Seconds(3));
        IAsyncSimpleResolver::THosts hostsToIps = {
                {"localhost", ""},
                {"127.0.0.1", ""},
                {"::1", ""},
        };
        resolver.StartResolve(hostsToIps, AF_INET);
        resolver.WaitForResults(TDuration::Seconds(3));
        UNIT_ASSERT_VALUES_EQUAL("127.0.0.1", hostsToIps["localhost"]);
        UNIT_ASSERT_VALUES_EQUAL("127.0.0.1", hostsToIps["127.0.0.1"]);
        UNIT_ASSERT_VALUES_EQUAL("", hostsToIps["::1"]);
    }

    Y_UNIT_TEST(TestResolveIPv6) {
        TAsyncSimpleResolver resolver(TDuration::Seconds(3));
        IAsyncSimpleResolver::THosts hostsToIps = {
                {"localhost", ""},
                {"127.0.0.1", ""},
                {"::1", ""},
        };
        resolver.StartResolve(hostsToIps, AF_INET6);
        resolver.WaitForResults(TDuration::Seconds(3));
        UNIT_ASSERT_VALUES_EQUAL("::1", hostsToIps["localhost"]);
        UNIT_ASSERT_VALUES_EQUAL("", hostsToIps["127.0.0.1"]);
        UNIT_ASSERT_VALUES_EQUAL("::1", hostsToIps["::1"]);
    }
}