#include "file_manager.h"

#include "file_arbiter.h"

namespace NSrvKernel {

TFileManager::TFileManager() noexcept
    : FileArbiter_(MakeHolder<TFileArbiter>())
{}

TFileManager::~TFileManager() = default;

TFileStat TFileManager::GetStat(const char* path, bool nofollow) const {
    return FileArbiter_->GetStat(path, nofollow);
}

TFileStat TFileManager::GetStat(FHANDLE f) const {
    return FileArbiter_->GetStat(f);
}

TFileStat TFileManager::GetStat(const TFsPath& path, bool nofollow) const {
    return FileArbiter_->GetStat(path, nofollow);
}

TFileStat TFileManager::GetStat(const TString& path, bool nofollow) const {
    return FileArbiter_->GetStat(path, nofollow);
}

TFileStat TFileManager::GetStat(const TFile& f) const {
    return FileArbiter_->GetStat(f);
}

THolder<IInputStream> TFileManager::GetInput(const TFile& file) const {
    return FileArbiter_->GetInput(file);
}

THolder<IInputStream> TFileManager::GetInput(const TString& file) const {
    return FileArbiter_->GetInput(file);
}


TFileManager::TMockGuard::TMockGuard(THolder<IFileArbiter> mock) noexcept
    : PrevArbiter_(std::move(TFileManager::Instance().FileArbiter_))
{
    TFileManager::Instance().VerifyTesting();
    TFileManager::Instance().FileArbiter_ = std::move(mock);
}

TFileManager::TMockGuard::~TMockGuard() {
    TFileManager::Instance().FileArbiter_ = std::move(PrevArbiter_);
}

}  // namespace NSrvKernel
