#pragma once

#include <balancer/kernel/helpers/default_instance.h>

#include <util/system/fstat.h>

#include <util/generic/ptr.h>

class IInputStream;

namespace NSrvKernel {

class IFileArbiter;

class TFileManager : public TWithMutableInstance<TFileManager> {
public:
    TFileManager() noexcept;
    ~TFileManager();

    TFileStat GetStat(const char* path, bool nofollow = false) const;
    TFileStat GetStat(FHANDLE f) const;
    TFileStat GetStat(const TFsPath& path, bool nofollow = false) const;
    TFileStat GetStat(const TString& path, bool nofollow = false) const;
    TFileStat GetStat(const TFile& f) const;

    THolder<IInputStream> GetInput(const TFile& file) const;
    THolder<IInputStream> GetInput(const TString& file) const;

    void EnableTesting() noexcept {
        Testing_ = true;
    }

public:
    class TMockGuard {
    public:
        TMockGuard(THolder<IFileArbiter> mock) noexcept;
        ~TMockGuard();

    private:
        THolder<IFileArbiter> PrevArbiter_;
    };

private:
    void VerifyTesting() noexcept {
        Y_VERIFY(Testing_, "Changing the guts of TFileManager in production code is forbidden."
                            "Did you forget to call EnableTesting()?");
    }

private:
    THolder<IFileArbiter> FileArbiter_;
    bool Testing_ = false;
};

}  // namespace NSrvKernel
