#pragma once

#include <balancer/kernel/helpers/errors.h>
#include <balancer/kernel/thread/threadedqueue.h>

#include <util/generic/string.h>
#include <util/system/fstat.h>

namespace NSrvKernel {

    TError CheckFileReadable(const char* file);

    class TThreadedFsValidationImpl: public TNonCopyable, public TThreadedQueue::ICallback {
    private:
        const TString Name_;
        TFileStat Stat_;
        TString FileRealPath_;
    public:
        using TAction = void (TThreadedFsValidationImpl::*)();
        TAction Action = nullptr;
    public:
        explicit TThreadedFsValidationImpl(const TStringBuf name) noexcept;
        void DoRun() override;
        void StatFunction() noexcept;
        void FileRealPathFunction() noexcept;

        const TString& Name() const noexcept {
            return Name_;
        }

        const TFileStat Stat() const noexcept {
            return Stat_;
        }

        // name collision with RealPath from dirut.h
        inline TString FileRealPath() const noexcept {
            return FileRealPath_;
        }

        void Error() noexcept {
            Y_ASSERT(false);
        }
    };

    class TThreadedStat: public TNonCopyable {
    private:
        using TImpl = TThreadedFsValidationImpl;
        THolder<TImpl> Impl_;
        TThreadedQueue* Queue_ = nullptr;
    public:
        explicit TThreadedStat(const TString& name, TThreadedQueue* queue) noexcept;
        ~TThreadedStat() = default;

        const TFileStat Stat() const noexcept;
    };

    class TThreadedRealPath: public TNonCopyable {
    private:
        using TImpl = TThreadedFsValidationImpl;
        THolder<TImpl> Impl_;
        TThreadedQueue* Queue_ = nullptr;
    public:
        explicit TThreadedRealPath(const TString& name, TThreadedQueue* queue) noexcept;
        ~TThreadedRealPath() = default;

        TString FileRealPath() const noexcept;
    };

}
