#include "shared_file_exists_checker.h"

namespace NSrvKernel {

TCheckerTask::TCheckerTask(TFsPath path)
    : Path_(std::move(path))
{}

bool TCheckerTask::Exists() const {
    return AtomicGet(Exists_);
}

bool TCheckerTask::Process() {
    AtomicSet(Exists_, Path_.Exists());
    return true;
}

TSharedFileExistsChecker::TSharedFileExistsChecker(TIntrusivePtr<TCheckerTask> checkerTask) noexcept
    : CheckerTask_(std::move(checkerTask))
{}

bool TSharedFileExistsChecker::Exists() const noexcept {
    if (!CheckerTask_) {
        return false;
    }
    return CheckerTask_->Exists();
}

bool TSharedFileExistsChecker::Empty() const noexcept {
    return CheckerTask_ ? false : true;
}

}  // namespace NSrvKernel
