#pragma once

#include <library/cpp/threading/task_scheduler/task_scheduler.h>

#include <util/generic/string.h>
#include <util/folder/path.h>
#include <util/datetime/base.h>
#include <util/generic/ptr.h>

#include <utility>


namespace NSrvKernel {
    class TCheckerTask : public TTaskScheduler::IRepeatedTask {
    public:
        explicit TCheckerTask(TFsPath path);

        bool Exists() const;

        bool Process() override;

    private:
        const TFsPath Path_;
        TAtomic Exists_ = false;
    };

    class TSharedFileExistsChecker : public TMoveOnly {
    public:
        TSharedFileExistsChecker() = default;

        explicit TSharedFileExistsChecker(TIntrusivePtr<TCheckerTask> checkerTask) noexcept;

        bool Exists() const noexcept;

        bool Empty() const noexcept;

    private:
        TIntrusivePtr<TCheckerTask> CheckerTask_ = nullptr;
    };
}
