#pragma once

#include <balancer/kernel/coro/coroutine.h>
#include <balancer/kernel/fs/shared_value.h>
#include <balancer/kernel/thread/threadedqueue.h>

#include <util/datetime/base.h>

#include <util/system/fstat.h>

#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NSrvKernel {

    class TSharedFileReloader {
    public:
        TSharedFileReloader(TContExecutor* executor, TThreadedQueue* queue,
                            TString path, TDuration timeout, THolder<ISharedDataLoader> loader) noexcept;

        void UpdateInterval(TDuration checkInterval) noexcept {
            CheckInterval_ = Min(CheckInterval_, checkInterval);
        }

        ISharedDataLoader* GetLoader() noexcept {
            return Loader_.Get();
        }

        void Start() noexcept;
        void Stop() noexcept;
        TInstant LastModifiedTime() const noexcept;

    private:
        TContExecutor* Executor_ = nullptr;
        TThreadedQueue* Queue_ = nullptr;

        THolder<ISharedDataLoader> Loader_;

        const TString Path_;
        TDuration CheckInterval_;

        TFileStat Stat_;
        TCoroutine Task_;
    };
}
