#pragma once

#include <util/generic/maybe.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NSrvKernel {
    class ISharedDataLoader {
    public:
        void Parse(TMaybe<TString>&& data) {
            return DoParse(std::move(data));
        }
        virtual ~ISharedDataLoader() {
        }

    private:
        virtual void DoParse(TMaybe<TString> data) = 0;
    };

    /*
     * Common class for parsing.
     * You need to write static function void T::Parse(TMaybe<TString> data, TSimpleSharedPtr<T>& current)
     * and save parsed value to current. If you want to drop value just save nullptr to current
     */
    template <typename T>
    class TSharedValue final : public ISharedDataLoader {
    public:
        using TValuePtr = TSimpleSharedPtr<T>;

        const TValuePtr Get() const noexcept {
            return Value_;
        }

    private:
        void DoParse(TMaybe<TString> data) override {
            T::Parse(std::move(data), Value_);
        }

    private:
        TValuePtr Value_;
    };
}
