#pragma once

#include <balancer/kernel/io/iobase.h>
#include <balancer/kernel/memory/chunks.h>

namespace NSrvKernel {
    class TThreadedQueue;

    TErrorOr<TChunkPtr> ThreadedFileReadAll(
        TString name, TThreadedQueue* queue, ui64 maxLength,
        TInstant deadline) noexcept;

    TErrorOr<ui64> ThreadedFileSend(
        TString name, TThreadedQueue* queue, IIoOutput* output) noexcept;
}
