#include <balancer/kernel/fs/file_manager.h>

#include <balancer/kernel/testing/file_arbiter_mock.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

using ::testing::A;

Y_UNIT_TEST_SUITE(TFileManagerTest) {
    const TString STRING_SAMPLE = "sample";
    constexpr char PATH_SAMPLE[] = "test.txt";
    constexpr FHANDLE FD_SAMPLE = 5;

    Y_UNIT_TEST(Test) {
        TFileManager::Instance().EnableTesting();

        auto fileArbiterMockPtr = MakeHolder<NSrvKernel::NTesting::TFileArbiterMock>();
        auto& fileArbiterMock = *fileArbiterMockPtr;

        TFileManager::TMockGuard guard{std::move(fileArbiterMockPtr)};

        // Basic aggregate tests
        // --------------------------------------------------------------------------------
        EXPECT_CALL(fileArbiterMock, GetStat(PATH_SAMPLE, true))
            .Times(1);
        TFileManager::Instance().GetStat(PATH_SAMPLE, true);

        EXPECT_CALL(fileArbiterMock, GetStat(FD_SAMPLE))
            .Times(1);
        TFileManager::Instance().GetStat(FD_SAMPLE);

        TFsPath path{PATH_SAMPLE};
        EXPECT_CALL(fileArbiterMock, GetStat(path.c_str(), true))
            .Times(1);
        TFileManager::Instance().GetStat(path, true);

        EXPECT_CALL(fileArbiterMock, GetStat(STRING_SAMPLE.c_str(), true))
            .Times(1);
        TFileManager::Instance().GetStat(STRING_SAMPLE, true);

        TFile file;
        EXPECT_CALL(fileArbiterMock, GetStat(INVALID_FHANDLE))
            .Times(1);
        TFileManager::Instance().GetStat(file);


        EXPECT_CALL(fileArbiterMock, GetInput(A<const TFile&>()))
            .Times(1);
        TFileManager::Instance().GetInput(file);

        EXPECT_CALL(fileArbiterMock, GetInput(STRING_SAMPLE))
            .Times(1);
        TFileManager::Instance().GetInput(STRING_SAMPLE);
        // --------------------------------------------------------------------------------
    }
}
