#pragma once

#include <balancer/kernel/memory/chunks.h>

#include <util/generic/string.h>
#include <util/generic/ymath.h>
#include <util/string/cast.h>

#include <cmath>

namespace NSrvKernel {

    template <class T2, class T1>
    inline static T2 CopyCast(T1 src) noexcept {
        static_assert(sizeof(T1) == sizeof(T2)
                      && std::is_trivially_copyable_v<T1> && std::is_trivially_copyable_v<T2>);
        T2 res;
        memcpy(&res, &src, sizeof(src));
        return res;
    }

    inline ui64 ClampDoubleToUI64(double d) {
        if (IsFinite(d)) {
            return (ui64)ClampVal<double>(d, 0., 0x1p64 - 0x1p11);
        } else {
            return IsNan(d) ? 0 : (d > 0 ? Max<ui64>() : 0);
        }
    }
}
