#include "common_parsers.h"

namespace NSrvKernel {

    void ParseMap(IConfig* cfg, std::function<void(const TString&, IConfig::IValue*)> func) {
        ParseMapStrict(cfg, [&](auto& key, auto* value) -> bool {
            func(key, value);
            return true;
        });
    }

    void ParseMapStrict(IConfig* cfg, std::function<bool(const TString&, IConfig::IValue*)> func) {
        using TCons = decltype(func);
        struct TParser : public IConfig::IFunc {
            START_PARSE
                if (C_(key, value)) {
                    return;
                }
            END_PARSE
            TParser(TCons c) : C_(c) {}
            TCons C_;
        } p{func};
        cfg->ForEach(&p);
    }

}
