#pragma once

#include <library/cpp/config/sax.h>
#include <util/generic/hash_set.h>
#include <util/network/ip.h>
#include <util/network/socket.h>
#include <util/string/builder.h>

namespace NSrvKernel {
    using NConfig::IConfig;

    /* Parsing map from config.
     * Usage example:
     * ParseMap(config, [&m = m](const auto& key, auto* value) {
     *     // key is either a string key or a stringified 0-based entry index. See the unit tests for indexing caveats.
     *     m.emplace_back(key, value->AsString());
     * });
     */
    void ParseMap(IConfig* config, std::function<void(const TString&, IConfig::IValue*)> func);

    void ParseMapStrict(IConfig* config, std::function<bool(const TString&, IConfig::IValue*)> func);

}
