#pragma once

#include <util/generic/singleton.h>
#include <util/thread/singleton.h>

namespace NSrvKernel {

    template <typename T>
    class TWithDefaultInstance {
    public:
        static inline const T& Instance() noexcept {
            return Default<T>();
        }
    };

    template <typename T>
    class TWithMutableInstance {
    public:
        static inline T& Instance() {
            return *Singleton<T>();
        }
    };

    template <typename T>
    class TWithThreadLocalInstance {
    public:
        static inline T& Instance() {
            return *FastTlsSingleton<T>();
        }
    };
}
