#pragma once

#include <tuple>

namespace NSrvKernel {

#define Y_BALANCER_TUPLE_EQ(T, ...) \
    auto AsTuple() const noexcept { return std::make_tuple(__VA_ARGS__); } \
    bool operator==(const T& o) const noexcept { return AsTuple() == o.AsTuple(); } \
    bool operator!=(const T& o) const noexcept { return !(*this == o); }

#define Y_BALANCER_TUPLE_OPS(T, ...) \
    Y_BALANCER_TUPLE_EQ(T, __VA_ARGS__) \
    bool operator <(const T& o) const noexcept { return AsTuple() < o.AsTuple(); } \
    bool operator <=(const T& o) const noexcept { return AsTuple() <= o.AsTuple(); } \
    bool operator >(const T& o) const noexcept { return !(AsTuple() <= o.AsTuple()); } \
    bool operator >=(const T& o) const noexcept { return !(AsTuple() < o.AsTuple()); }

#define Y_BALANCER_GETTER(F) auto F() const noexcept { return F ## _; }
#define Y_BALANCER_CREF_GETTER(F) const auto& F() const noexcept { return F ## _; }

#define Y_BALANCER_INIT_WORKER_COUNTER(name, tmpl, workerId) name(tmpl.name, workerId)

}
