#include "ranges.h"

namespace NSrvKernel {
    template <>
    TVector<ui64> RangesToIntervals<size_t>(const TRanges<size_t>& ranges) {
        return TVector<ui64>{ ranges.begin(), ranges.end() };
    }

    template <>
    TVector<ui64> RangesToIntervals<ui8>(const TRanges<ui8>& ranges) {
        return TVector<ui64>{ ranges.begin(), ranges.end() };
    }

    template <>
    TVector<ui64> RangesToIntervals<TDuration>(const TRanges<TDuration>& ranges) {
        TVector<ui64> result(Reserve(ranges.size()));
        for (auto x : ranges) {
            result.push_back(x.MicroSeconds());
        }
        return result;
    }
}
