#include <balancer/kernel/helpers/cast.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TCastTest) {
    Y_UNIT_TEST(ClampDoubleToUI64) {
        UNIT_ASSERT_VALUES_EQUAL(
            0, NSrvKernel::ClampDoubleToUI64(0));
        UNIT_ASSERT_VALUES_EQUAL(
            0, NSrvKernel::ClampDoubleToUI64(std::numeric_limits<double>::quiet_NaN()));
        UNIT_ASSERT_VALUES_EQUAL(
            0, NSrvKernel::ClampDoubleToUI64(std::numeric_limits<double>::signaling_NaN()));
        UNIT_ASSERT_VALUES_EQUAL(
            Max<ui64>(), NSrvKernel::ClampDoubleToUI64(std::numeric_limits<double>::infinity()));
        UNIT_ASSERT_VALUES_EQUAL(
            0, NSrvKernel::ClampDoubleToUI64(-std::numeric_limits<double>::infinity()));


        UNIT_ASSERT_VALUES_EQUAL(
            Max<ui64>() - 0x7FF, NSrvKernel::ClampDoubleToUI64(2. * Max<ui64>()));
        UNIT_ASSERT_VALUES_EQUAL(
            Max<ui64>() - 0x7FF, NSrvKernel::ClampDoubleToUI64(Max<ui64>()));
        UNIT_ASSERT_VALUES_EQUAL(
            Max<ui64>() - 0x7FF, NSrvKernel::ClampDoubleToUI64(Max<ui64>() - 0x3FF));
        UNIT_ASSERT_VALUES_EQUAL(
            Max<ui64>() - 0x7FF, NSrvKernel::ClampDoubleToUI64(Max<ui64>() - 0x7FF));
        UNIT_ASSERT_VALUES_EQUAL(
            Max<ui64>() - 0xFFF, NSrvKernel::ClampDoubleToUI64(Max<ui64>() - 0xFFF));
    }
}
