#include <balancer/kernel/helpers/common_parsers.h>
#include <library/cpp/config/sax.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TTestCommonParsers) {
    Y_UNIT_TEST(TestParseMap) {
        TStringStream ss{
            "instance = {"
            "  key_x = 'val_x';"
            "  key_y = 'val_y';"
            "};"
        };
        auto cfg = NConfig::ConfigParser(ss);
        THashMap<TString, TString> res;
        NSrvKernel::ParseMap(cfg.Get(), [&res](const auto& key, auto* val) {
            res[key] = val->AsString();
        });
        UNIT_ASSERT_VALUES_EQUAL(res.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(res.at("key_x"), "val_x");
        UNIT_ASSERT_VALUES_EQUAL(res.at("key_y"), "val_y");
    }

    Y_UNIT_TEST(TestParseArray) {
        TStringStream ss{
            "instance = {"
            "  'val_0';"
            "  'val_1';"
            "};"
        };
        auto cfg = NConfig::ConfigParser(ss);
        THashMap<TString, TString> res;
        NSrvKernel::ParseMap(cfg.Get(), [&res](const auto& key, auto* val) {
            res[key] = val->AsString();
        });
        UNIT_ASSERT_VALUES_EQUAL(res.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(res.at("0"), "val_0");
        UNIT_ASSERT_VALUES_EQUAL(res.at("1"), "val_1");
    }

    Y_UNIT_TEST(TestParseMixed) {
        TStringStream ss{
            "instance = {"
            "  key_x = 'val_x';"
            "  'val_1';"
            "  key_y = 'val_y';"
            "  'val_3';"
            "};"
        };
        auto cfg = NConfig::ConfigParser(ss);
        THashMap<TString, TString> res;
        NSrvKernel::ParseMap(cfg.Get(), [&res](const auto& key, auto* val) {
            res[key] = val->AsString();
        });
        UNIT_ASSERT_VALUES_EQUAL(res.size(), 4);
        UNIT_ASSERT_VALUES_EQUAL(res.at("key_x"), "val_x");
        UNIT_ASSERT_VALUES_EQUAL(res.at("key_y"), "val_y");
        UNIT_ASSERT_VALUES_EQUAL(res.at("1"), "val_1");
        UNIT_ASSERT_VALUES_EQUAL(res.at("2"), "val_3");
    }
}
