#include <balancer/kernel/helpers/reqid.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TReqIdGenTest) {
    Y_UNIT_TEST(TestGenReqId) {
        TStringStream str;
        NSrvKernel::GenReqId(str, TInstant::MicroSeconds(1543230616987654ull), Max<ui64>());
        UNIT_ASSERT_VALUES_EQUAL(str.Str(), "1543230616987654-18446744073709551615");
    }

    Y_UNIT_TEST(TestGenMarketReqId) {
        TStringStream str;
        NSrvKernel::GenMarketReqId(str, TInstant::MicroSeconds(1543230616987654ull), 0xF0F1F2F3F4F5F6F7ull);
        UNIT_ASSERT_VALUES_EQUAL(str.Str(), "1543230616987/f7f6f5f4f3f2f1f00668bb608f7b0500");
    }

    Y_UNIT_TEST(TestGenAdfoxReqId) {
        TStringStream str;
        NSrvKernel::GenAdfoxReqId(str, Max<ui64>());
        UNIT_ASSERT_VALUES_EQUAL(str.Str(), "18446744073709551615");
    }

    Y_UNIT_TEST(TestGenSearchReqId) {
        TStringStream str;
        NSrvKernel::GenSearchReqId(str, TInstant::MicroSeconds(1543230616987654ull), Max<ui64>(), "cool-host-name.sas.yp-c.yandex.net");
        UNIT_ASSERT_VALUES_EQUAL(str.Str(), "1543230616987654-18446744073709551615-cool-host-name-BAL");
    }
}
