#include <balancer/kernel/helpers/yuid.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TYuidGenTest) {
    Y_UNIT_TEST(TestYuid) {
        UNIT_ASSERT_VALUES_EQUAL(NSrvKernel::GetYuid(Max<ui64>(), TInstant::MicroSeconds(1543230616987654ull)),
            "2095516151543230616");
        UNIT_ASSERT_VALUES_EQUAL(NSrvKernel::GetYuid(0, TInstant::MicroSeconds(1543230616987654ull)),
            "1000000001543230616");
        UNIT_ASSERT_VALUES_EQUAL(NSrvKernel::GetYuid(900'000'000, TInstant::MicroSeconds(1543230616987654ull)),
            "1000000001543230616");
        UNIT_ASSERT_VALUES_EQUAL(NSrvKernel::GetYuid(899'999'999, TInstant::MicroSeconds(1543230616987654ull)),
            "9999999991543230616");
    }
}
