#pragma once

#include <balancer/kernel/helpers/default_instance.h>
#include <balancer/kernel/regexp/regexp_pire.h>


namespace NSrvKernel {
    struct TSetCookieFsm : public TFsm {
        TSetCookieFsm() noexcept
            : TFsm("Set-Cookie", TFsm::TOptions().SetCaseInsensitive(true).SetSurround(false))
        {}

        static const TSetCookieFsm& Instance() noexcept;
    };

    struct THostFsm : public TFsm {
        THostFsm() noexcept
            : TFsm("Host", TFsm::TOptions().SetCaseInsensitive(true))
        {}

        static const THostFsm& Instance() noexcept;
    };

    struct TExpectFsm : public TFsm {
        TExpectFsm() noexcept
            : TFsm("Expect", TFsm::TOptions().SetCaseInsensitive(true).SetSurround(false))
        {}

        static const TExpectFsm& Instance() noexcept;
    };

    struct TContentTypeFsm : public TFsm {
        TContentTypeFsm() noexcept
            : TFsm("Content-Type", TFsm::TOptions().SetCaseInsensitive(true).SetSurround(false))
        {}

        static const TContentTypeFsm& Instance() noexcept;
    };

    struct TContentLengthFsm : public TFsm {
        TContentLengthFsm() noexcept
            : TFsm("Content-Length", TFsm::TOptions().SetCaseInsensitive(true).SetSurround(false))
        {}

        static const TContentLengthFsm& Instance() noexcept;
    };

    struct TTransferEncodingFsm : public TFsm {
        TTransferEncodingFsm() noexcept
            : TFsm("Transfer-Encoding", TFsm::TOptions().SetCaseInsensitive(true).SetSurround(false))
        {}

        static const TTransferEncodingFsm& Instance() noexcept;
    };

    struct T100ContinueFsm : public TFsm {
        T100ContinueFsm() noexcept
            : TFsm("100-continue", TFsm::TOptions().SetCaseInsensitive(true).SetSurround(false))
        {}

        static const T100ContinueFsm& Instance() noexcept;
    };

    class TTrueFsm : public TFsm {
    public:
        TTrueFsm() noexcept
            : TFsm("1|Yes|True|Da", TFsm::TOptions().SetCaseInsensitive(true))
        {}

        static const TTrueFsm& Instance() noexcept;
    };

    struct TRefererFsm : public TFsm {
        TRefererFsm() noexcept
            : TFsm("Referer", TFsm::TOptions().SetCaseInsensitive(true))
        {}

        static const TRefererFsm& Instance() noexcept;
    };

    struct TCookieFsm : public TFsm {
        TCookieFsm() noexcept
            : TFsm("Cookie", TFsm::TOptions().SetCaseInsensitive(true))
        {}

        static const TCookieFsm& Instance() noexcept;
    };

    struct TUpgradeFsm : public TFsm {
        TUpgradeFsm() noexcept
            : TFsm("Upgrade", TFsm::TOptions().SetCaseInsensitive(true))
        {}

        static const TUpgradeFsm& Instance() noexcept;
    };

    struct TNameFsm : public TFsm {
        TNameFsm() noexcept
            : TFsm("[a-z][-a-z0-9_]+", NRegExp::TFsm::TOptions().SetCaseInsensitive(true))
        {}

        static const TNameFsm& Instance() noexcept;
    };
}
