#pragma once

#include <util/generic/hash_set.h>
#include <util/generic/strbuf.h>

#include <library/cpp/digest/lower_case/hash_ops.h>
#include <library/cpp/regex/pire/regexp.h>

namespace NSrvKernel {
    bool CheckHeaderName(TStringBuf name) noexcept;

    bool CheckHeaderValue(TStringBuf val) noexcept;

    bool CheckRestrictedHeaderName(TStringBuf val) noexcept;

    bool CheckRestrictedHeaderRegexp(const NRegExp::TFsm& fsm) noexcept;

    const TStringBuf RestrictedHeadersListString() noexcept;
}
