#pragma once

#include "httpencoder.h"

namespace NSrvKernel {

class THttpOutput final : public IHttpOutput {
public:
    explicit THttpOutput(IIoOutput* const slave, const ui16 requestMinorVersion,
                         const bool headRequest, const bool requestIsHttp2,
                         const bool requestKeepAlive)
        : Encoder_(slave)
        , RequestMinorVersion_(requestMinorVersion)
        , HeadRequest_(headRequest)
        , RequestIsHttp2_(requestIsHttp2)
        , RequestKeepAlive_(requestKeepAlive)
        , NeedForceClose_(!requestKeepAlive)
    {
        Y_ASSERT(slave != nullptr);
    }

    /**
     * Checks whether balancer must close connection with client after sending body from backend.
     **/
    bool NeedForceClose() const noexcept {
        return NeedForceClose_;
    }

private:
    TError DoSendHead(TResponse&& response, const bool forceClose, TInstant deadline) override;

    TError DoSendTrailers(THeaders &&headers, TInstant deadline) override;

    TError DoSend(TChunkList lst, TInstant deadline) noexcept override {
        return Encoder_.Send(std::move(lst), deadline);
    }

private:
    // Notice that THttpOutput works with IIoOutput slave since it never calls SendHead on it.
    NPrivate::THttpEncoder Encoder_;
    ui16 RequestMinorVersion_ = 1;
    bool HeadRequest_ = false;
    bool RequestIsHttp2_ = false;
    bool RequestKeepAlive_ = true;
    bool NeedForceClose_ = false;
};

}  // namespace NSrvKernel
