#pragma once

#include <balancer/kernel/helpers/errors.h>

#include <balancer/kernel/memory/chunks.h>

#include <array>

namespace NSrvKernel {

    class TMessageHeadEndingScanner {
    public:
        explicit TMessageHeadEndingScanner(TString* buffer, bool scanHeaders = false) noexcept;

        // Takes new data chunks and scans them for a request ending. If `lst` contains double CRLF (or LF if legacy), it moves
        // the prefix to `Buffer_` and the rest to `body`. Otherwise it moves `lst` to `Buffer_` and `body` is empty.
        // Returns true if the request is complete, false if it's not, an error if the request is incorrect.
        TErrorOr<bool> ProcessNewDataChunkAndSeparateBody(TChunkList lst, TChunkList& body) noexcept;

    private:
        TString* const Buffer_;
        size_t CrlfOrLfCount_ = 0;
        bool ExpectedNewLine_ = false;
        bool ScanHeaders_ = false;
        bool EmptyMessage_ = true;
    };

}
