#include <balancer/kernel/http/parser/response_builder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TResponseBuilderTest) {
    Y_UNIT_TEST(SmokingTest) {
        TResponse response = BuildResponse().Version11()
                                            .Code(HTTP_OK)
                                            .Reason("OK")
                                            .ContentLength(42);
        UNIT_ASSERT_EQUAL(1, response.ResponseLine().MajorVersion);
        UNIT_ASSERT_EQUAL(1, response.ResponseLine().MinorVersion);
        UNIT_ASSERT_EQUAL(HTTP_OK, response.ResponseLine().StatusCode);
        UNIT_ASSERT_EQUAL("OK", response.ResponseLine().Reason.AsStringBuf());
        UNIT_ASSERT(response.Props().ContentLength);
        UNIT_ASSERT_EQUAL(42, *response.Props().ContentLength);
    }

    Y_UNIT_TEST(ImplicitReasonStringTest) {
        for (auto code : {HTTP_PARTIAL_CONTENT, HTTP_SWITCHING_PROTOCOLS, HTTP_PROCESSING}) {
            TResponse response = BuildResponse().Version10()
                                                .Code(code);
            UNIT_ASSERT_EQUAL(1, response.ResponseLine().MajorVersion);
            UNIT_ASSERT_EQUAL(0, response.ResponseLine().MinorVersion);
            UNIT_ASSERT_EQUAL(HttpCodeStr(code), response.ResponseLine().Reason.AsStringBuf());
        }
    }

    Y_UNIT_TEST(HeaderTest) {
        TVector<std::pair<TString, TString>> headers = {{"abc", "def"},
                                                        {"123", "456"}};
        TResponse response = BuildResponse().Version11()
                                            .Code(HTTP_OK)
                                            .ChunkedTransfer()
                                            .Header("abc", "def")
                                            .Header("123", "456");
        UNIT_ASSERT(response.Props().ChunkedTransfer);
        for (const auto& [key, value] : headers) {
            auto header = response.Headers().FindValues(key);
            UNIT_ASSERT_EQUAL(key, header->first);
            UNIT_ASSERT_EQUAL(value, header->second[0]);

            auto values = response.Headers().GetValuesRef(key);
            auto constValueBrackets = std::as_const(response.Headers()).GetValuesRef(key);
            UNIT_ASSERT_EQUAL(value, values[0]);
            UNIT_ASSERT_EQUAL(value, constValueBrackets[0]);
        }
    }
}
