#include <balancer/kernel/http/parser/http.h>
#include <balancer/kernel/http/parser/url.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TUrlTest) {
    Y_UNIT_TEST(TestCheckUrl) {
        UNIT_ASSERT(CheckUrl("/"));
        UNIT_ASSERT(CheckUrl("/led/zeppelin"));
        UNIT_ASSERT(CheckUrl("/led?zeppelin"));
        UNIT_ASSERT(CheckUrl("/led?zeppelin=stairway"));

        UNIT_ASSERT(!CheckUrl(""));
        UNIT_ASSERT(!CheckUrl("/ "));
        UNIT_ASSERT(!CheckUrl(" /"));
        UNIT_ASSERT(!CheckUrl("?wat"));
        UNIT_ASSERT(!CheckUrl("%20"));
        UNIT_ASSERT(!CheckUrl("%/"));
        UNIT_ASSERT(!CheckUrl("/\r"));
        UNIT_ASSERT(!CheckUrl("/\n"));
        UNIT_ASSERT(!CheckUrl("/?\n"));
        UNIT_ASSERT(!CheckUrl("/?\r"));
    }

    Y_UNIT_TEST(TestCheckProxyUrl) {
        UNIT_ASSERT(!CheckUrl("http://yndx.ru/search"));
        UNIT_ASSERT(!CheckUrl("https://yndx.ru/search"));
        UNIT_ASSERT(!CheckUrl("h2://yndx.ru/search"));
    }
};
