#include <balancer/kernel/http/string_storage/string_storage.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/maybe.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TStringStorageTest) {
    Y_UNIT_TEST(TestStringBufNonOwning) {
        TMaybe<TStringStorage> storage;
        TString data = "data";
        {
            TStringBuf temp = data;
            storage.ConstructInPlace(temp);
        }
        UNIT_ASSERT_VALUES_EQUAL(storage->AsStringBuf(), "data");
        data = "DATA";
        UNIT_ASSERT_VALUES_EQUAL(storage->AsStringBuf(), "DATA");
    }

    Y_UNIT_TEST(TestStringBufOwning) {
        TString data("data");
        TStringStorage storage(data);
        UNIT_ASSERT_VALUES_EQUAL(storage.AsStringBuf(), "data");
        data = "DATA";
        UNIT_ASSERT_VALUES_EQUAL(storage.AsStringBuf(), "data");
    }

    Y_UNIT_TEST(TestWithChunkList) {
        TString data("data");
        TStringStorage storage = TStringStorage(std::move(data));
        UNIT_ASSERT_VALUES_EQUAL(storage.AsStringBuf(), "data");
    }

    Y_UNIT_TEST(TestMove) {
        TMaybe<TStringStorage> anotherStorage;
        TString data = "data";
        {
            TStringStorage storage = TStringStorage(TStringBuf(data));
            anotherStorage.ConstructInPlace(std::move(storage));
        }
        UNIT_ASSERT_VALUES_EQUAL(anotherStorage->AsStringBuf(), "data");
    }

    Y_UNIT_TEST(TestMakeOwned) {
        char data[5] = "data";
        TStringStorage storage(data);
        UNIT_ASSERT_VALUES_EQUAL(storage.AsStringBuf(), "data");
        storage.MakeOwned();
        data[3] = 'e';
        UNIT_ASSERT_VALUES_EQUAL(storage.AsStringBuf(), "data");
    }
};
