#pragma once

#include "http2_stream.h"

#include <balancer/kernel/client_request/face.h>

#include <functional>

namespace NBalancerClient {
struct THttp2RequestSummary {};

class THttp2Request: public NSrvKernel::IClientRequest {
  public:
    struct TCallbacks {
        typedef void (OnChunkSentHandler)(ui64 handleId, size_t size);
        typedef void (OnChunkReceivedHandler)(ui64 handleId, size_t size);
        typedef void (OnEndOfInputStreamHandler)(ui64 handleId);

        typedef void (OnFrameSent)(ui64 handleId, const nghttp2_frame* frame);
        typedef void (OnFrameRecv)(ui64 handleId, const nghttp2_frame* frame);

        std::function<OnChunkSentHandler> OnChunkSent;
        std::function<OnChunkReceivedHandler> OnChunkReceived;
        std::function<OnEndOfInputStreamHandler> OnEndOfInputStream;

        std::function<OnFrameSent> OnFrameSentHandler;
        std::function<OnFrameRecv> OnFrameRecvHandler;
    };

    THttp2Request(TCallbacks callbacks = {});

    const TMaybe<THttp2RequestSummary>& GetSummary() const noexcept;
  private:
    NSrvKernel::TError DoRun(const NSrvKernel::TConnDescr &descr, const NSrvKernel::TBackendProtocols &protocols, const NSrvKernel::THostInfo& hostInfo) noexcept override;

    TCallbacks Callbacks_;
    TMaybe<THttp2RequestSummary> Summary_ = THttp2RequestSummary{};
};
}
